<?php
/**
 * The template for displaying posts in the Audio post format
 *
 * @package WordPress
 * @subpackage TemplateMela
 * @since TemplateMela 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <div class="entry-main-content">
	<?php if ( is_search() || !is_single()) : // Only display Excerpts for Search and not single pages ?>
	  <?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
		
		<div class="entry-thumbnail">
			<?php 
				the_post_thumbnail('smarteye-blogpostlist');
				$postImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
				?>
				<?php 
				if(!empty($postImage)): ?>
					<div class="block_hover">
					<div class="links">
					<a href="<?php echo esc_url($postImage); ?>" title="<?php esc_html_e( 'Click to view Full Image', 'smarteye' );?>" data-lightbox="example-set" class="icon mustang-gallery"><i class="fa fa-plus"></i></a> <a href="<?php echo esc_url(get_permalink()); ?>" title="<?php esc_html_e( 'Click to view Read More', 'smarteye' );?>" class="icon readmore"><i class="fa fa-link"></i></a> 
					</div>
				</div>
				<?php endif; ?>
		</div>
		
			
		  <?php else : ?>
			 
  		<?php endif; ?>
		<div class="entry-main-header">		
			<?php 
				if( $post->post_title == '' ) : 
					$entry_meta_class = "empty-entry-header";
				else :
					$entry_meta_class = "";
				endif; ?>
				<header class="entry-header <?php echo esc_attr($entry_meta_class); ?>">					
					<h1 class="entry-title"> <a href="<?php esc_url(the_permalink()); ?>" rel="bookmark">
					<?php the_title(); ?>
					</a><?php smarteye_sticky_post(); ?><span class="blog-icon"></span></h1>					
				</header><!-- entry-header -->
				
				<div class="entry-content-inner"> 
					<div class="entry-meta-inner">    
						<div class="entry-meta">	
						<div class="entry-content-date">
							<?php smarteye_post_entry_date(); ?>
						</div>											
						<?php smarteye_author_link(); ?>								
						<?php smarteye_comments_link(); ?>														
						</div><!-- entry-meta -->
					</div><!-- entry-meta-inner -->
				</div><!-- entry-content-inner -->
		</div><!-- entry-main-header -->	
  	<?php endif; ?>
	
	<div class="entry-content-other">		
		<?php if ( is_search() || !is_single()) : // Only display Excerpts for Search and not single pages ?>
			<div class="entry-summary">
				<div class="excerpt"> <?php echo smarteye_posts_short_description(); ?> </div>
			</div><!-- .entry-summary -->
			<?php else : ?>
			
			<div class="entry-main-header">				
				<?php 
				if( $post->post_title == '' ) : 
				$entry_meta_class = "empty-entry-header";
				else :
				$entry_meta_class = "";
				endif; ?>
				<header class="entry-header <?php echo esc_attr($entry_meta_class); ?>">					
				<h1 class="entry-title"> 
				<?php the_title(); ?>
				<?php smarteye_sticky_post(); ?> </h1>					
				</header><!-- .entry-header -->
				
				<div class="entry-content-inner"> 
					<div class="entry-meta-inner">    
						<div class="entry-meta">	
							<div class="entry-content-date">
								<?php smarteye_post_entry_date(); ?>
							</div>						  							
							<?php smarteye_author_link(); ?>							
							<?php edit_post_link( esc_html__( 'Edit', 'smarteye' ), '&nbsp&nbsp/&nbsp&nbsp;<span class="edit-link"><i class="fa fa-pencil"></i>', '</span>' ); ?>																				
							<?php smarteye_tags_links(); ?>											
							<?php smarteye_categories_links(); ?>	
							</div><!-- .entry-meta -->
						</div><!-- .entry-meta-inner -->
				</div><!-- .entry-content-inner -->
			</div><!-- .entry-main-header -->
			
			<div class="entry-thumbnail">
			<?php 
				the_post_thumbnail('smarteye-blogpostlist');
				$postImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
				?>
			</div>
			
			<div class="entry-content">
			 <?php the_content( wp_kses( __('Continue reading <span class="meta-nav">&rarr;</span>', 'smarteye' ),smarteye_allowed_html())); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'smarteye' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
			</div><!-- .entry-content -->
				
		<?php endif; ?>
	</div> <!-- entry-content-other -->
  </div>
</article>
<!-- #post -->