<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WordPress
 * @subpackage TemplateMela
 * @since TemplateMela 1.0
 */
?>
<?php tm_content_after(); ?>
</div>
<!-- .main-content-inner -->
</div>
<!-- .main_inner -->
</div>
<!-- #main -->
<?php tm_footer_before(); ?>
<footer id="colophon" class="site-footer">
	
	<?php if ( is_active_sidebar( 'footer-top-area' ) ) : ?>
			<div class="footer-top">
				<div class="footer-top-inner">
					<?php dynamic_sidebar('footer-top-area'); ?>
				</div>
			</div>
	<?php endif; ?>
	  <div class="theme-container">
		  <div class="footer_inner">
			
			<?php tm_footer_inside(); ?>
			<?php get_sidebar('footer'); ?>
			
			<!-- .footer-bottom -->
		  </div>
		  <div class="footer-bottom">
		  <div class="footer-center">
				
				<?php if ( has_nav_menu('footer-menu') ) { ?>    
				<div class="footer-menu-links">
				<?php
							$tm_footer_menu=array(
							'menu' => 'TM Footer Navigation',
							'depth'=> 1,
							'echo' => false,
							'menu_class'      => 'footer-menu', 
							'container'       => '', 
							'container_class' => '', 
							'theme_location' => 'footer-menu'
							);
							echo wp_nav_menu($tm_footer_menu);				    
							?>
				</div><!-- #footer-menu-links -->	
				<?php } ?> 
			   		  
					  <div class="site-info">  <?php esc_html__( 'Copyright', 'smarteye' ); ?> &copy; <?php echo esc_attr(date('Y')); ?> <a href="<?php echo esc_url(get_option('tm_footer_link')); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php echo esc_attr(get_option('tm_footer_slog'));?>
						</a>
						<?php do_action( 'tm_credits' ); ?>
					  </div>
				
				<?php if (is_active_sidebar('footer-bottom-widget-area')) : ?>
				<div class="footer-bottom-inner">	
					<?php dynamic_sidebar('footer-bottom-widget-area'); ?>
				</div>
				<?php endif; ?>
		
			 
			  
			</div>
			</div>
	</div>
  <!--. Footer inner -->
</footer>
<!-- #colophon -->
<?php tm_footer_after(); ?>
</div>
<!-- #page -->
<?php smarteye_gotop(); ?>
<?php smarteye_get_widget('before-end-body-widget'); ?>
<?php wp_footer(); ?>
</body>
</html>
