<?php
/**
 * The Header for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Templatemela
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width,initial-scale=1">

<link rel="profile" href="http://gmpg.org/xfn/11"/>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"/>

<?php tm_header(); ?>
 	
<?php wp_head();?> 
</head>
<body <?php body_class(); ?>>

<?php if ( get_option('tm_control_panel') == 'yes' ) do_action('tm_show_panel'); ?>

<div id="page" class="hfeed site">
<?php if ( get_header_image() ) : ?>
<div id="site-header"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"> <img src="<?php header_image(); ?>" width="<?php echo esc_attr(get_custom_header()->width); ?>" height="<?php echo esc_attr(get_custom_header()->height); ?>" alt="<?php echo esc_html_e('Siteheader','smarteye'); ?>"> </a> </div>
<?php endif; ?>
<!-- Header -->
<?php tm_header_before(); ?>

<header id="masthead" class="site-header site-header-fix header <?php echo esc_attr(tm_sidebar_position()); ?>">
	<?php if (get_option('tm_show_topbar') == 'yes') : ?>
		<div class="topbar-outer">
			<div class="topbar-main theme-container">													
						<?php $welcome_text = get_option('tm_topbar_welcome_text');
							 if(!empty($welcome_text)):?>
								<span class="site-welcome-message"><h1><?php echo esc_attr(get_option('tm_topbar_welcome_text'))."&nbsp;".get_bloginfo( 'name' ); ?></h1></span>
						<?php endif; ?>
						<div class="topbar-link">
							<span class="topbar-link-toggle"></span>
						 <div class="topbar-link-wrapper">
							<?php if ( has_nav_menu('header-menu') ) { ?>    
							<div class="header-menu-links">						
									<?php 
									// Woo commerce Header Cart
									$tm_header_menu =array(
									'menu' => 'TM Header Navigation',
									'depth'=> 1,
									'echo' => false,
									'menu_class'      => 'header-menu', 
									'container'       => '', 
									'container_class' => '', 
									'theme_location' => 'header-menu'
									);
									echo wp_nav_menu($tm_header_menu);				    
									?>
							</div>
							<?php } ?> 				
							<?php if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
							<div class="header_login">
									<div class="header_logout">																			
										<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="account"><i class="fa fa-user"></i><?php echo esc_html_e('My Account','smarteye'); ?></a>	
										<a href="<?php  echo get_permalink( get_option('woocommerce_checkout_page_id') ); ?>" class="checkout"><i class="fa fa-shopping-cart" aria-hidden="true"></i><?php echo esc_html_e('Checkout','smarteye'); ?></a>									
									</div>
							</div>		
							<?php endif; ?>	
							</div>
						</div>
			</div>
		</div>
	<?php endif; ?>
	
  	<div class="site-header-main">
  
    <div class="header-main">
		<div class="header-left">
			<div class="navigation-menu navigation-block navigation-fix">
			<h3 class="menu-toggle"><?php esc_html_e( 'Menu', 'smarteye' ); ?></h3>
			<div id="navbar" class="navbar default navigation-inner vertical-menu">
			<nav id="site-navigation" class="navigation main-navigation">																			
			
			<a class="screen-reader-text skip-link" href="#content" title="<?php esc_html_e( 'Skip to content', 'smarteye' ); ?>"><?php esc_html_e( 'Skip to content', 'smarteye' ); ?></a>	
			<div class="mega-menu">
			<?php wp_nav_menu( array( 'theme_location' => 'primary','menu_class' => 'mega' ) ); ?>			
			</div>	
			<div class="mobile-menu">	
			<span class="close-menu"></span>	
			<?php wp_nav_menu( array( 'theme_location' => 'primary','menu_class' => 'mobile-menu-inner') ); ?>
			</div>	
			</nav><!-- #site-navigation -->
			</div>						
			
			</div><!-- End navigation-menu -->
		</div>				
		<div class="header-middle">
			<div class="header-logo">
			<?php if (get_option('tm_logo_image') != '') : ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
				<?php smarteye_get_logo(); ?>
				</a>
			<?php else: ?>
				<h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
					<?php bloginfo( 'name' ); ?>
					</a>
				</h1>
			<?php endif; ?>
			<?php if(get_option('tm_showsite_description') == 'yes') : ?>
				<h2 class="site-description">
					<?php bloginfo( 'description' ); ?>
				</h2>
			<?php endif; // End tm_showsite_description ?>
			</div>
			<div class="header-mob-logo">
			<?php if (get_option('tm_mob_logo_image') != '') : ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
				<?php smarteye_get_mob_logo(); ?>
				</a>
			<?php else: ?>
				<h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
					<?php bloginfo( 'name' ); ?>
					</a>
				</h1>
			<?php endif; ?>
			<?php if(get_option('tm_showsite_description') == 'yes') : ?>
				<h2 class="site-description">
					<?php bloginfo( 'description' ); ?>
				</h2>
			<?php endif; // End tm_showsite_description ?>
			</div>
		</div><!-- End header_center -->
		
      	<?php tm_header_inside(); ?>
	 
		<div class="header-right">				
			<?php if (is_active_sidebar('header-search')) : ?>				
					<div class="header-search">						
						<?php smarteye_get_widget('header-search');  ?>					
					</div>				
			<?php endif; ?>
			<?php 	// Woo commerce Header Cart
			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) :
				if ( is_active_sidebar( 'header-widget' ) ):?>		
			<div class="header_cart headercart-block">					
				<div class="cart togg">
				<?php global $woocommerce;
				ob_start();?>						
				<div id="shopping_cart" class="shopping_cart tog" title="<?php esc_html_e('View your shopping cart', 'smarteye'); ?>">
				
				<a class="cart-contents" href="<?php echo esc_url($woocommerce->cart->get_cart_url()); ?>" title="<?php esc_html_e('View your shopping cart', 'smarteye'); ?>"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'smarteye'), $woocommerce->cart->cart_contents_count);?></a>
				</div>	
				<?php global $woocommerce; ?>
				<?php smarteye_get_widget('header-widget'); ?>		
			</div>										
		</div>	
		<?php 
				endif;
				endif; ?>	
		<?php if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
				<div class="header-login">
					<div class="account-toggle"></div>
						<div class="account-container">																	
							<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="login"><?php echo esc_html_e('My Account','smarteye'); ?></a>
							<?php if( function_exists( 'YITH_WCWL' ) ) : ?>
							<a href="<?php  echo get_permalink( get_option('yith_wcwl_wishlist_page_id') ); ?>" class="wishlist"><?php echo esc_html_e('Wishlist','smarteye'); ?></a>
							<?php endif; ?>	
							<a href="<?php  echo get_permalink( get_option('woocommerce_checkout_page_id') ); ?>" class="checkout"><?php echo esc_html_e('Checkout','smarteye'); ?></a>										
						</div> 
					</div>		
		<?php endif; ?>																											
		</div><!-- End header_right -->					    
  </div><!-- End header-main -->  			  
</div><!-- End site-header-main -->

</header><!-- #masthead -->
<?php tm_header_after(); ?>
<?php tm_main_before(); ?>
<!-- Center -->
<?php 
$shop = '0';
	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) :
	if(is_shop())
		$tm_page_layout = 'wide-page';
		$shop = '1';
	endif;
?>
<div id="main" class="site-main <?php if (get_option('tm_show_topbar') == 'yes') echo "extra"; ?>">
<div class="main_inner">
	<!-- Start main slider -->	
	 <?php if (is_page_template('page-templates/home.php') ) : ?>
				<div id="revolutionslider">
					<div class="revolutionslider-inner">
						<?php if ( in_array( 'revslider/revslider.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>	
						<?php echo do_shortcode('[rev_slider '.get_option('tm_revslider_alias').']'); ?>
						<?php endif; ?>
					</div>
				</div>			
	<?php endif; ?>
	<!-- End main slider -->
	<?php if ( !is_page_template('page-templates/home.php')) : ?>
<div class="page-title header">
  <div class="page-title-inner">
  
    <h1 class="entry-title-main">
<?php	    	  
	   if($shop == '1') {
	       		if(is_shop()) :
		    		echo '';
				elseif(is_blog()):
				        esc_html_e( 'Blog', 'smarteye' );
				elseif(is_search()) :
					printf( esc_html__( 'Search Results for: "%s"', 'smarteye' ), get_search_query() ); 
				elseif( is_front_page() && is_home()):
				    esc_html_e( 'Blog', 'smarteye' );	    
				elseif(is_singular('post')):
					esc_html_e( 'Single Blog', 'smarteye' );	    
				else :
				    the_title();
	        	endif; 	
	   }else {		   		
			 if(is_blog()):
				esc_html_e( 'Blog', 'smarteye' );		
			elseif(is_search()) :
				printf( esc_html__( 'Search Results for: "%s"', 'smarteye' ), get_search_query() ); 		
			elseif(is_singular('post') ) :
				esc_html_e( 'Single Blog', 'smarteye' );				
			else :
				    the_title();
			endif; 	
		}  
	  ?>
    </h1>
    <?php smarteye_breadcrumbs(); ?>
  </div>
</div>
<?php endif; ?>
<?php 
	$tm_page_layout = tm_page_layout(); 
	if( isset( $tm_page_layout) && !empty( $tm_page_layout ) ):
	$tm_page_layout = $tm_page_layout; 
	else:
	$tm_page_layout = '';
	endif;
	
if ( $tm_page_layout == 'wide-page' ) : ?>
<div class="main-content-inner-full">
<?php else: 
	if(is_archive() || is_tag() || is_404()) : ?>
		<div class="main-content">
	<?php else : ?>
		<div class="main-content-inner <?php echo esc_attr(tm_sidebar_position()); ?>">
	<?php endif; ?>
<?php endif; ?>
<?php tm_content_before(); ?>
